require 'rspec_helper'
require 'vaToolSet/vaToolSet_PageObject'
require 'loginLogout'
require_relative '../module/DBUtility'


class AccessVarUtility
  include PageObject
  include DBUtility

  def initialize(driver)
    @driver = driver
    @vts_po  = VaToolSet_PageObject.new(@driver)
  end

  def access_var_utility(user_info)
    log = LoginLogout.new(@driver)
    setStaffUserDisclaimer(user_info["userId"], user_info["vista_location"])

    log.login(user_info)
    @vts_po.home.varUtilOpen_element.when_visible(TIME_OUT_LIMIT)
    #@vts_po.home.varUtilOpen_element.click

    button_element = @driver.button( :id=>'open-var-utility-btn')
    @driver.execute_script("$(arguments[0]).click();",button_element)
  end

  def access_va_tool_set(user_info)
    log_temp = LoginLogout.new(@driver)
    log_temp.login(user_info)
  end

  def logout_login_ends_on_var_utility(user_info)
    @vts_po.userMenu.userMenu_element.when_visible(TIME_OUT_LIMIT)
    #@vts_po.userMenu.userMenu_element.click

    user_menu = @driver.button(:id => 'user-menu-toggle-btn')
    @driver.execute_script("$(arguments[0]).click();", user_menu)

    @vts_po.userMenu.logOut_element.when_visible(TIME_OUT_LIMIT)

    button_element = @driver.button(:id => 'logout')
    @driver.execute_script("$(arguments[0]).click();",button_element)

    #@user_menu.logOut
    @vts_po.common.waitWhileSpinnerPresent()

    @vts_po.launchpad.launchpadTitle_element.when_present(TIME_OUT_LIMIT)
    Watir::Wait.until {@vts_po.launchpad.launchpadTitle == "Launchpad"}

    @driver.goto(BASE_URL)
    access_var_utility(user_info)
  end

end